<?php
/*--------------------------------------------------------------
   Dropdown.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItems;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown\Item;
use Webmozart\Assert\Assert;

class Dropdown implements Option
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var OptionTitles
     */
    private $titles;
    
    /**
     * @var string
     */
    private $value;
    
    /**
     * @var DropdownItems
     */
    private $items;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(Id $id, string $value, DropdownItems $items, OptionTitles $titles)
    {
        Assert::stringNotEmpty($value);
        Assert::inArray($value,
                        array_map(function (Item $item) {
                            return $item->value()->value();
                        },
                            iterator_to_array($items)));
        
        $this->id     = $id;
        $this->titles = $titles;
        $this->value  = $value;
        $this->items  = $items;
        $this->type   = "dropdown";
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Id $id, string $value, DropdownItems $items, OptionTitles $titles): self
    {
        return new self($id, $value, $items, $titles);
    }
    
    
    /**
     * @inheritDoc
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): string
    {
        return $this->value;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
    
    
    /**
     * @inheritDoc
     */
    public function titles(): OptionTitles
    {
        return $this->titles;
    }
    
    
    /**
     * Return dropdown items.
     */
    public function items(): DropdownItems
    {
        return $this->items;
    }
}